/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health.problem;

import pl.allegro.tech.hermes.api.SubscriptionHealth;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionMetrics;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.AbstractSubscriptionHealthProblemIndicator;

public class MalfunctioningIndicator
extends AbstractSubscriptionHealthProblemIndicator {
    private final double max5xxErrorsRatio;
    private final double minSubscriptionRateForReliableMetrics;

    public MalfunctioningIndicator(double max5xxErrorsRatio, double minSubscriptionRateForReliableMetrics) {
        this.max5xxErrorsRatio = max5xxErrorsRatio;
        this.minSubscriptionRateForReliableMetrics = minSubscriptionRateForReliableMetrics;
    }

    @Override
    public boolean problemOccurs(SubscriptionHealthContext context) {
        SubscriptionMetrics subscriptionMetrics = context.getSubscriptionMetrics();
        return this.areSubscriptionMetricsReliable(subscriptionMetrics) && this.isCode5xxErrorsRateHigh(subscriptionMetrics);
    }

    private boolean areSubscriptionMetricsReliable(SubscriptionMetrics subscriptionMetrics) {
        return subscriptionMetrics.getRate() > this.minSubscriptionRateForReliableMetrics;
    }

    private boolean isCode5xxErrorsRateHigh(SubscriptionMetrics subscriptionMetrics) {
        double rate;
        double code5xxErrorsRate = subscriptionMetrics.getCode5xxErrorsRate();
        return code5xxErrorsRate > this.max5xxErrorsRatio * (rate = subscriptionMetrics.getRate());
    }

    @Override
    public SubscriptionHealth.Problem getProblem() {
        return SubscriptionHealth.Problem.MALFUNCTIONING;
    }
}

