/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health.problem;

import pl.allegro.tech.hermes.api.SubscriptionHealth;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.AbstractSubscriptionHealthProblemIndicator;

public class LaggingIndicator
extends AbstractSubscriptionHealthProblemIndicator {
    private final int maxLagInSeconds;

    public LaggingIndicator(int maxLagInSeconds) {
        this.maxLagInSeconds = maxLagInSeconds;
    }

    @Override
    public boolean problemOccurs(SubscriptionHealthContext context) {
        double topicRate;
        long subscriptionLag = context.getSubscriptionMetrics().getLag();
        double lagInSeconds = (double)subscriptionLag / (topicRate = context.getTopicMetrics().getRate());
        return lagInSeconds > (double)this.maxLagInSeconds;
    }

    @Override
    public SubscriptionHealth.Problem getProblem() {
        return SubscriptionHealth.Problem.LAGGING;
    }
}

