/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.owner;

import java.util.List;
import java.util.Optional;
import pl.allegro.tech.hermes.api.ErrorCode;
import pl.allegro.tech.hermes.api.Owner;
import pl.allegro.tech.hermes.management.domain.ManagementException;

public interface OwnerSource {
    public String name();

    public boolean exists(String var1);

    public Owner get(String var1) throws OwnerNotFound;

    default public Optional<Autocompletion> autocompletion() {
        return Optional.empty();
    }

    public static class OwnerNotFound
    extends ManagementException {
        public OwnerNotFound(String source, String id) {
            super("Owner of id '" + id + "' not found in source " + source);
        }

        @Override
        public ErrorCode getCode() {
            return ErrorCode.OWNER_NOT_FOUND;
        }
    }

    public static interface Autocompletion {
        public List<Owner> ownersMatching(String var1);
    }
}

