/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health.problem;

import pl.allegro.tech.hermes.api.SubscriptionHealth;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionMetrics;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.AbstractSubscriptionHealthProblemIndicator;

public class UnreachableIndicator
extends AbstractSubscriptionHealthProblemIndicator {
    private final double maxOtherErrorsRatio;
    private final double minSubscriptionRateForReliableMetrics;

    public UnreachableIndicator(double maxOtherErrorsRatio, double minSubscriptionRateForReliableMetrics) {
        this.maxOtherErrorsRatio = maxOtherErrorsRatio;
        this.minSubscriptionRateForReliableMetrics = minSubscriptionRateForReliableMetrics;
    }

    @Override
    public boolean problemOccurs(SubscriptionHealthContext context) {
        SubscriptionMetrics subscriptionMetrics = context.getSubscriptionMetrics();
        return this.areSubscriptionMetricsReliable(subscriptionMetrics) && this.isOtherErrorsRateHigh(subscriptionMetrics);
    }

    private boolean areSubscriptionMetricsReliable(SubscriptionMetrics subscriptionMetrics) {
        return subscriptionMetrics.getRate() > this.minSubscriptionRateForReliableMetrics;
    }

    private boolean isOtherErrorsRateHigh(SubscriptionMetrics subscriptionMetrics) {
        double rate;
        double otherErrorsRate = subscriptionMetrics.getOtherErrorsRate();
        return otherErrorsRate > this.maxOtherErrorsRatio * (rate = subscriptionMetrics.getRate());
    }

    @Override
    public SubscriptionHealth.Problem getProblem() {
        return SubscriptionHealth.Problem.UNREACHABLE;
    }
}

