/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Query;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.Matcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherException;

public class MatcherQuery<T>
implements Query<T> {
    private static final Logger logger = LoggerFactory.getLogger(MatcherQuery.class);
    private final Matcher matcher;
    private final ObjectMapper objectMapper;

    private MatcherQuery(Matcher matcher, ObjectMapper objectMapper) {
        this.matcher = matcher;
        this.objectMapper = objectMapper;
    }

    public Stream<T> filter(Stream<T> input) {
        return input.filter(this.getPredicate());
    }

    public Predicate<T> getPredicate() {
        return value -> {
            try {
                return this.matcher.match(this.convertToMap(value));
            }
            catch (MatcherException e) {
                logger.info("Failed to match {}, skipping", value, (Object)e);
                return false;
            }
        };
    }

    private Map convertToMap(T value) {
        return (Map)this.objectMapper.convertValue(value, Map.class);
    }

    public static <T> Query<T> fromMatcher(Matcher matcher, ObjectMapper objectMapper) {
        return new MatcherQuery<T>(matcher, objectMapper);
    }
}

