/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api.auth;

import javax.ws.rs.container.ContainerRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.api.auth.SecurityProvider;
import pl.allegro.tech.hermes.management.domain.subscription.CreatorRights;

@Component
public class ManagementRights {
    private final TopicRepository topicRepository;

    @Autowired
    public ManagementRights(TopicRepository topicRepository) {
        this.topicRepository = topicRepository;
    }

    public boolean isUserAllowedToManageTopic(Topic topic, ContainerRequestContext requestContext) {
        return this.isAdmin(requestContext) || this.getOwnershipResolver(requestContext).isUserAnOwner(topic.getOwner());
    }

    public boolean isUserAllowedToCreateSubscription(Subscription subscription, ContainerRequestContext requestContext) {
        return !this.topicRepository.isSubscribingRestricted(subscription.getTopicName()) || this.isAdmin(requestContext) || this.isTopicOwner(subscription, requestContext);
    }

    public boolean isUserAllowedToManageSubscription(Subscription subscription, ContainerRequestContext requestContext) {
        return this.isAdmin(requestContext) || this.isTopicOwner(subscription, requestContext) || this.isSubscriptionOwner(subscription, requestContext);
    }

    private boolean isTopicOwner(Subscription subscription, ContainerRequestContext requestContext) {
        return this.getOwnershipResolver(requestContext).isUserAnOwner(this.topicRepository.getTopicDetails(subscription.getTopicName()).getOwner());
    }

    private boolean isSubscriptionOwner(Subscription subscription, ContainerRequestContext requestContext) {
        return this.getOwnershipResolver(requestContext).isUserAnOwner(subscription.getOwner());
    }

    private boolean isAdmin(ContainerRequestContext requestContext) {
        return requestContext.getSecurityContext().isUserInRole("admin");
    }

    private SecurityProvider.OwnershipResolver getOwnershipResolver(ContainerRequestContext requestContext) {
        return (SecurityProvider.OwnershipResolver)requestContext.getProperty("ownership-resolver");
    }

    public CreatorRights getSubscriptionCreatorRights(ContainerRequestContext requestContext) {
        return new SubscriptionCreatorRights(requestContext);
    }

    private class SubscriptionCreatorRights
    implements CreatorRights {
        private ContainerRequestContext requestContext;

        private SubscriptionCreatorRights(ContainerRequestContext requestContext) {
            this.requestContext = requestContext;
        }

        @Override
        public boolean allowedToManage(Subscription subscription) {
            return ManagementRights.this.isUserAllowedToManageSubscription(subscription, this.requestContext);
        }

        @Override
        public boolean allowedToCreate(Subscription subscription) {
            return ManagementRights.this.isUserAllowedToCreateSubscription(subscription, this.requestContext);
        }
    }
}

