/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Ticker;
import java.time.Clock;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.common.clock.ClockFactory;
import pl.allegro.tech.hermes.management.config.HttpClientProperties;
import pl.allegro.tech.hermes.management.config.MetricsProperties;
import pl.allegro.tech.hermes.management.config.TopicProperties;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionLagSource;
import pl.allegro.tech.hermes.management.infrastructure.graphite.CachingGraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.graphite.WebTargetGraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.metrics.NoOpSubscriptionLagSource;
import pl.allegro.tech.hermes.management.stub.MetricsPaths;

@Configuration
@EnableConfigurationProperties(value={TopicProperties.class, MetricsProperties.class, HttpClientProperties.class})
public class ManagementConfiguration {
    @Autowired
    MetricsProperties metricsProperties;
    @Autowired
    HttpClientProperties httpClientProperties;

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public MetricRegistry metricRegistry() {
        return new MetricRegistry();
    }

    @Bean
    public Client jerseyClient() {
        ClientConfig config = new ClientConfig();
        config.property("jersey.config.client.connectTimeout", (Object)this.httpClientProperties.getConnectTimeout());
        config.property("jersey.config.client.readTimeout", (Object)this.httpClientProperties.getReadTimeout());
        return ClientBuilder.newClient((javax.ws.rs.core.Configuration)config);
    }

    @Bean
    public MetricsPaths metricsPaths() {
        return new MetricsPaths(this.metricsProperties.getPrefix());
    }

    @Bean
    public GraphiteClient graphiteClient() {
        WebTargetGraphiteClient underlyingGraphiteClient = new WebTargetGraphiteClient(this.jerseyClient().target(this.metricsProperties.getGraphiteHttpUri()));
        return new CachingGraphiteClient(underlyingGraphiteClient, Ticker.systemTicker(), this.metricsProperties.getCacheTtlInSeconds(), this.metricsProperties.getCacheSize());
    }

    @Bean
    @ConditionalOnMissingBean
    public SubscriptionLagSource consumerLagSource() {
        return new NoOpSubscriptionLagSource();
    }

    @Bean
    public Clock clock() {
        return new ClockFactory().provide();
    }
}

