/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health.problem;

import pl.allegro.tech.hermes.api.SubscriptionHealth;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionMetrics;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.AbstractSubscriptionHealthProblemIndicator;

public class TimingOutIndicator
extends AbstractSubscriptionHealthProblemIndicator {
    private final double maxTimeoutsRatio;
    private final double minSubscriptionRateForReliableMetrics;

    public TimingOutIndicator(double maxTimeoutsRatio, double minSubscriptionRateForReliableMetrics) {
        this.maxTimeoutsRatio = maxTimeoutsRatio;
        this.minSubscriptionRateForReliableMetrics = minSubscriptionRateForReliableMetrics;
    }

    @Override
    public boolean problemOccurs(SubscriptionHealthContext context) {
        SubscriptionMetrics subscriptionMetrics = context.getSubscriptionMetrics();
        return this.areSubscriptionMetricsReliable(subscriptionMetrics) && this.isTimeoutsRateHigh(subscriptionMetrics);
    }

    private boolean areSubscriptionMetricsReliable(SubscriptionMetrics subscriptionMetrics) {
        return subscriptionMetrics.getRate() > this.minSubscriptionRateForReliableMetrics;
    }

    private boolean isTimeoutsRateHigh(SubscriptionMetrics subscriptionMetrics) {
        double rate;
        double timeoutsRate = subscriptionMetrics.getTimeoutsRate();
        return timeoutsRate > this.maxTimeoutsRatio * (rate = subscriptionMetrics.getRate());
    }

    @Override
    public SubscriptionHealth.Problem getProblem() {
        return SubscriptionHealth.Problem.TIMING_OUT;
    }
}

