/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import com.wordnik.swagger.annotations.ApiOperation;
import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.api.RawSchema;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.management.domain.topic.schema.SchemaService;
import pl.allegro.tech.hermes.schema.SchemaVersion;

@Path(value="topics/{topicName}/schema")
public class SchemaEndpoint {
    private final SchemaService schemaService;
    private final TopicService topicService;

    @Autowired
    public SchemaEndpoint(SchemaService schemaService, TopicService topicService) {
        this.schemaService = schemaService;
        this.topicService = topicService;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get schema", httpMethod="GET")
    public Response get(@PathParam(value="topicName") String qualifiedTopicName) {
        Optional<RawSchema> rawSchema = this.schemaService.getSchema(qualifiedTopicName);
        return rawSchema.map(RawSchema::value).map(v -> Response.ok((Object)v).build()).orElse(Response.noContent().build());
    }

    @GET
    @Path(value="{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get schema", httpMethod="GET")
    public Response get(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="version") int version) {
        Optional<RawSchema> rawSchema = this.schemaService.getSchema(qualifiedTopicName, SchemaVersion.valueOf((int)version));
        return rawSchema.map(RawSchema::value).map(v -> Response.ok((Object)v).build()).orElse(Response.noContent().build());
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"topicOwner", "admin"})
    @ApiOperation(value="Save schema", httpMethod="POST")
    public Response save(@PathParam(value="topicName") String qualifiedTopicName, @DefaultValue(value="true") @QueryParam(value="validate") boolean validate, String schema) {
        Topic topic = this.topicService.getTopicDetails(TopicName.fromQualifiedName((String)qualifiedTopicName));
        this.schemaService.registerSchema(topic, schema, validate);
        this.notifyFrontendSchemaChanged(qualifiedTopicName);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private void notifyFrontendSchemaChanged(String qualifiedTopicName) {
        this.topicService.touchTopic(TopicName.fromQualifiedName((String)qualifiedTopicName));
    }

    @DELETE
    @RolesAllowed(value={"topicOwner", "admin"})
    @ApiOperation(value="Delete schema", httpMethod="DELETE")
    public Response delete(@PathParam(value="topicName") String qualifiedTopicName) {
        this.schemaService.deleteAllSchemaVersions(qualifiedTopicName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

