/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import org.javers.core.Javers;
import org.javers.core.diff.Diff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.management.domain.Auditor;

public class LoggingAuditor
implements Auditor {
    private static final Logger logger = LoggerFactory.getLogger(LoggingAuditor.class);
    private final Javers javers;
    private final ObjectMapper objectMapper;

    public LoggingAuditor(Javers javers, ObjectMapper objectMapper) {
        this.javers = (Javers)Preconditions.checkNotNull((Object)javers);
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Override
    public void objectCreated(String username, Object createdObject) {
        this.ignoringExceptions(() -> logger.info("User {} has created new {} {}.", new Object[]{username, createdObject.getClass().getSimpleName(), this.objectMapper.writeValueAsString(createdObject)}));
    }

    @Override
    public void objectRemoved(String username, String removedObjectType, String removedObjectName) {
        logger.info("User {} has removed {} {}.", new Object[]{username, removedObjectType, removedObjectName});
    }

    @Override
    public void objectUpdated(String username, Object oldObject, Object newObject) {
        this.ignoringExceptions(() -> {
            Diff diff = this.javers.compare(oldObject, newObject);
            logger.info("User {} has updated {} {}. {}", new Object[]{username, oldObject.getClass().getSimpleName(), this.objectMapper.writeValueAsString(oldObject), diff});
        });
    }

    private void ignoringExceptions(Wrapped wrapped) {
        try {
            wrapped.execute();
        }
        catch (Exception e) {
            logger.info("Audit log failed {}.", (Throwable)e);
        }
    }

    @FunctionalInterface
    private static interface Wrapped {
        public void execute() throws Exception;
    }
}

