/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query.matcher;

import java.util.EnumMap;
import java.util.Map;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.AndMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.ComparisonMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.EqualityMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.InMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.LikeMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherFactory;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherNotFoundException;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.NotMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.OrMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.parser.Operator;

public class MatcherFactories {
    private static final Map<Operator, MatcherFactory> FACTORIES = new EnumMap<Operator, MatcherFactory>(Operator.class);

    public static MatcherFactory getMatcherFactory(String operator) {
        try {
            return MatcherFactories.getMatcherFactory(Operator.from(operator));
        }
        catch (IllegalArgumentException e) {
            throw new MatcherNotFoundException(String.format("Unrecognized operator: '%s'", operator));
        }
    }

    public static MatcherFactory defaultMatcher() {
        return MatcherFactories.getMatcherFactory(Operator.EQ);
    }

    private static MatcherFactory getMatcherFactory(Operator operator) {
        return FACTORIES.get((Object)operator);
    }

    private static void registerFactories() {
        FACTORIES.put(Operator.EQ, (path, node, parser) -> new EqualityMatcher(path, parser.parseValue(node)));
        FACTORIES.put(Operator.NE, (path, node, parser) -> new NotMatcher(new EqualityMatcher(path, parser.parseValue(node))));
        FACTORIES.put(Operator.LIKE, (path, node, parser) -> new LikeMatcher(path, parser.parseValue(node)));
        FACTORIES.put(Operator.IN, (path, node, parser) -> new InMatcher(path, parser.parseArrayValue(node)));
        FACTORIES.put(Operator.NOT, (path, node, parser) -> new NotMatcher(parser.parseNode(node)));
        FACTORIES.put(Operator.AND, (path, node, parser) -> new AndMatcher(parser.parseArrayNodes(node)));
        FACTORIES.put(Operator.OR, (path, node, parser) -> new OrMatcher(parser.parseArrayNodes(node)));
        FACTORIES.put(Operator.GREATER_THAN, (path, node, parser) -> new ComparisonMatcher(path, parser.parseValue(node), (a, b) -> a > b));
        FACTORIES.put(Operator.LOWER_THAN, (path, node, parser) -> new ComparisonMatcher(path, parser.parseValue(node), (a, b) -> a < b));
    }

    static {
        MatcherFactories.registerFactories();
    }
}

