/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionHealth;
import pl.allegro.tech.hermes.api.SubscriptionMetrics;
import pl.allegro.tech.hermes.api.TopicMetrics;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContextCreator;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthProblemIndicator;

@Component
public class SubscriptionHealthChecker {
    private final Set<SubscriptionHealthProblemIndicator> problemIndicators;
    private final SubscriptionHealthContextCreator contextCreator = new SubscriptionHealthContextCreator();

    @Autowired
    public SubscriptionHealthChecker(Set<SubscriptionHealthProblemIndicator> problemIndicators) {
        this.problemIndicators = problemIndicators;
    }

    public SubscriptionHealth checkHealth(Subscription subscription, TopicMetrics topicMetrics, SubscriptionMetrics subscriptionMetrics) {
        if (this.isSuspended(subscription)) {
            return SubscriptionHealth.HEALTHY;
        }
        return this.getActiveSubscriptionHealth(subscription, topicMetrics, subscriptionMetrics);
    }

    private boolean isSuspended(Subscription subscription) {
        return subscription.getState() == Subscription.State.SUSPENDED;
    }

    private SubscriptionHealth getActiveSubscriptionHealth(Subscription subscription, TopicMetrics topicMetrics, SubscriptionMetrics subscriptionMetrics) {
        try {
            SubscriptionHealthContext healthContext = this.contextCreator.createContext(subscription, topicMetrics, subscriptionMetrics);
            Set<SubscriptionHealth.Problem> healthProblems = this.getHealthProblems(healthContext);
            return SubscriptionHealth.of(healthProblems);
        }
        catch (NumberFormatException e) {
            return SubscriptionHealth.NO_DATA;
        }
    }

    private Set<SubscriptionHealth.Problem> getHealthProblems(SubscriptionHealthContext healthContext) {
        return this.problemIndicators.stream().map(indicator -> indicator.getProblemIfPresent(healthContext)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }
}

