/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import java.util.List;
import java.util.Optional;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.api.OwnerId;
import pl.allegro.tech.hermes.api.UnhealthySubscription;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSources;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionService;

@Path(value="unhealthy")
public class UnhealthyEndpoint {
    private final OwnerSources ownerSources;
    private final SubscriptionService subscriptionService;

    @Autowired
    public UnhealthyEndpoint(OwnerSources ownerSources, SubscriptionService subscriptionService) {
        this.ownerSources = ownerSources;
        this.subscriptionService = subscriptionService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/")
    public List<UnhealthySubscription> listUnhealthy(@QueryParam(value="ownerSourceName") String ownerSourceName, @QueryParam(value="ownerId") String id, @DefaultValue(value="true") @QueryParam(value="respectMonitoringSeverity") boolean respectMonitoringSeverity) {
        Optional<OwnerId> ownerId = this.resolveOwnerId(ownerSourceName, id);
        return ownerId.isPresent() ? this.subscriptionService.getUnhealthyForOwner(ownerId.get(), respectMonitoringSeverity) : this.subscriptionService.getAllUnhealthy(respectMonitoringSeverity);
    }

    private Optional<OwnerId> resolveOwnerId(String ownerSourceName, String id) {
        return this.ownerSources.getByName(ownerSourceName).map(ownerSource -> new OwnerId(ownerSource.name(), id));
    }
}

