/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import pl.allegro.tech.hermes.management.config.CrowdProperties;
import pl.allegro.tech.hermes.management.domain.owner.CrowdOwnerSource;
import pl.allegro.tech.hermes.management.infrastructure.crowd.CachedCrowdClient;
import pl.allegro.tech.hermes.management.infrastructure.crowd.RestCrowdClient;

@Configuration
@EnableConfigurationProperties(value={CrowdProperties.class})
@ConditionalOnProperty(value={"owner.crowd.enabled"})
public class CrowdConfiguration {
    @Bean(value={"managementRequestFactory"})
    @ConfigurationProperties(prefix="management.restTemplate")
    public ClientHttpRequestFactory clientHttpRequestFactory() {
        return new HttpComponentsClientHttpRequestFactory();
    }

    @Bean(name={"crowdRestTemplate"})
    public RestTemplate restTemplate(CrowdProperties properties) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(properties.getConnectionTimeoutMillis()).setSocketTimeout(properties.getSocketTimeoutMillis()).build();
        CloseableHttpClient client = HttpClientBuilder.create().setMaxConnTotal(properties.getMaxConnections()).setMaxConnPerRoute(properties.getMaxConnectionsPerRoute()).setDefaultRequestConfig(requestConfig).build();
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)client);
        return new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }

    @Bean
    @Order(value=1)
    public CrowdOwnerSource crowdOwnerSource(CrowdProperties crowdProperties, @Qualifier(value="crowdRestTemplate") RestTemplate restTemplate) {
        return new CrowdOwnerSource(new CachedCrowdClient(new RestCrowdClient(restTemplate, crowdProperties), crowdProperties));
    }
}

