/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.glassfish.jersey.client.ClientConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import pl.allegro.tech.hermes.management.config.SchemaRepositoryProperties;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.schema.CompiledSchemaRepository;
import pl.allegro.tech.hermes.schema.DirectCompiledSchemaRepository;
import pl.allegro.tech.hermes.schema.DirectSchemaVersionsRepository;
import pl.allegro.tech.hermes.schema.RawSchemaClient;
import pl.allegro.tech.hermes.schema.SchemaCompilersFactory;
import pl.allegro.tech.hermes.schema.SchemaRepository;
import pl.allegro.tech.hermes.schema.SchemaVersionsRepository;
import pl.allegro.tech.hermes.schema.confluent.SchemaRegistryRawSchemaClient;
import pl.allegro.tech.hermes.schema.schemarepo.SchemaRepoRawSchemaClient;

@Configuration
@EnableConfigurationProperties(value={SchemaRepositoryProperties.class})
public class SchemaRepositoryConfiguration {
    @Autowired
    @Lazy
    TopicService topicService;
    @Autowired
    private SchemaRepositoryProperties schemaRepositoryProperties;

    @Bean(name={"schemaRepositoryClient"})
    public Client schemaRepositoryClient(ObjectMapper mapper) {
        ClientConfig config = new ClientConfig().property("jersey.config.client.connectTimeout", (Object)this.schemaRepositoryProperties.getConnectionTimeoutMillis()).property("jersey.config.client.readTimeout", (Object)this.schemaRepositoryProperties.getSocketTimeoutMillis()).register((Object)new JacksonJsonProvider(mapper));
        return ClientBuilder.newClient((javax.ws.rs.core.Configuration)config);
    }

    @Bean
    @ConditionalOnMissingBean(value={RawSchemaClient.class})
    @ConditionalOnProperty(value={"schema.repository.type"}, havingValue="schema_repo")
    public RawSchemaClient schemaRepoRawSchemaClient(Client httpClient) {
        return new SchemaRepoRawSchemaClient(httpClient, URI.create(this.schemaRepositoryProperties.getServerUrl()));
    }

    @Bean
    @ConditionalOnMissingBean(value={RawSchemaClient.class})
    @ConditionalOnProperty(value={"schema.repository.type"}, havingValue="schema_registry")
    public RawSchemaClient schemaRegistryRawSchemaClient(@Qualifier(value="schemaRepositoryClient") Client httpClient, ObjectMapper objectMapper) {
        return new SchemaRegistryRawSchemaClient(httpClient, URI.create(this.schemaRepositoryProperties.getServerUrl()), objectMapper, this.schemaRepositoryProperties.isValidationEnabled());
    }

    @Bean
    public SchemaRepository aggregateSchemaRepository(RawSchemaClient rawSchemaClient) {
        DirectSchemaVersionsRepository versionsRepository = new DirectSchemaVersionsRepository(rawSchemaClient);
        DirectCompiledSchemaRepository avroSchemaRepository = new DirectCompiledSchemaRepository(rawSchemaClient, SchemaCompilersFactory.avroSchemaCompiler());
        return new SchemaRepository((SchemaVersionsRepository)versionsRepository, (CompiledSchemaRepository)avroSchemaRepository);
    }
}

