/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health;

import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionMetrics;
import pl.allegro.tech.hermes.api.TopicMetrics;

public final class SubscriptionHealthContext {
    private final Subscription subscription;
    private final double topicRate;
    private final double subscriptionRate;
    private final double timeoutsRate;
    private final double otherErrorsRate;
    private final double code4xxErrorsRate;
    private final double code5xxErrorsRate;
    private final double batchRate;
    private final long lag;

    SubscriptionHealthContext(Subscription subscription, TopicMetrics topicMetrics, SubscriptionMetrics subscriptionMetrics) {
        this.subscription = subscription;
        this.topicRate = Double.parseDouble(topicMetrics.getRate());
        this.subscriptionRate = Double.parseDouble(subscriptionMetrics.getRate());
        this.timeoutsRate = Double.parseDouble(subscriptionMetrics.getTimeouts());
        this.otherErrorsRate = Double.parseDouble(subscriptionMetrics.getOtherErrors());
        this.code4xxErrorsRate = Double.parseDouble(subscriptionMetrics.getCodes4xx());
        this.code5xxErrorsRate = Double.parseDouble(subscriptionMetrics.getCodes5xx());
        this.batchRate = Double.parseDouble(subscriptionMetrics.getBatchRate());
        this.lag = subscriptionMetrics.getLag();
    }

    public boolean subscriptionHasRetryOnError() {
        if (this.subscription.isBatchSubscription()) {
            return this.subscription.getBatchSubscriptionPolicy().isRetryClientErrors();
        }
        return this.subscription.getSerialSubscriptionPolicy().isRetryClientErrors();
    }

    public double getSubscriptionRateRespectingDeliveryType() {
        if (this.subscription.isBatchSubscription()) {
            return this.batchRate;
        }
        return this.subscriptionRate;
    }

    public double getOtherErrorsRate() {
        return this.otherErrorsRate;
    }

    public double getTimeoutsRate() {
        return this.timeoutsRate;
    }

    public double getCode4xxErrorsRate() {
        return this.code4xxErrorsRate;
    }

    public double getCode5xxErrorsRate() {
        return this.code5xxErrorsRate;
    }

    public long getLag() {
        return this.lag;
    }

    public double getTopicRate() {
        return this.topicRate;
    }
}

