/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.common.message.wrapper.AvroMessageContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.DeserializationMetrics;
import pl.allegro.tech.hermes.common.message.wrapper.JsonMessageContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.MessageContentWrapper;
import pl.allegro.tech.hermes.management.config.MessageProperties;
import pl.allegro.tech.hermes.schema.SchemaRepository;

@Configuration
@EnableConfigurationProperties(value={MessageProperties.class})
public class MessageConfiguration {
    @Autowired
    MessageProperties messageProperties;
    @Autowired
    Clock clock;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    SchemaRepository schemaRepository;
    @Autowired
    MetricRegistry metricRegistry;

    @Bean
    MessageContentWrapper messageContentWrapper() {
        return new MessageContentWrapper(this.jsonMessageContentWrapper(), new AvroMessageContentWrapper(this.clock), this.schemaRepository, () -> true, new DeserializationMetrics(this.metricRegistry));
    }

    private JsonMessageContentWrapper jsonMessageContentWrapper() {
        return new JsonMessageContentWrapper(this.messageProperties.getContentRoot(), this.messageProperties.getMetadataContentRoot(), this.objectMapper);
    }
}

