/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.ConsumerGroup;
import pl.allegro.tech.hermes.api.ConsumerGroupMember;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicPartition;
import pl.allegro.tech.hermes.common.kafka.ConsumerGroupId;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapper;
import pl.allegro.tech.hermes.management.infrastructure.kafka.service.LogEndOffsetChecker;

public class ConsumerGroupsDescriber {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerGroupsDescriber.class);
    private final KafkaNamesMapper kafkaNamesMapper;
    private final AdminClient adminClient;
    private final LogEndOffsetChecker logEndOffsetChecker;

    public ConsumerGroupsDescriber(KafkaNamesMapper kafkaNamesMapper, AdminClient adminClient, LogEndOffsetChecker logEndOffsetChecker) {
        this.kafkaNamesMapper = kafkaNamesMapper;
        this.adminClient = adminClient;
        this.logEndOffsetChecker = logEndOffsetChecker;
    }

    public Optional<ConsumerGroup> describeConsumerGroup(SubscriptionName subscription) {
        ConsumerGroupId consumerGroupId = this.kafkaNamesMapper.toConsumerGroupId(subscription);
        try {
            return this.describeConsumerGroup(consumerGroupId);
        }
        catch (Exception e) {
            logger.error("Failed to describe group with id: {}", (Object)consumerGroupId.asString(), (Object)e);
            return Optional.empty();
        }
    }

    private Optional<ConsumerGroup> describeConsumerGroup(ConsumerGroupId consumerGroupId) throws ExecutionException, InterruptedException {
        Map topicPartitionOffsets = (Map)this.adminClient.listConsumerGroupOffsets(consumerGroupId.asString()).partitionsToOffsetAndMetadata().get();
        Optional description = ((Map)this.adminClient.describeConsumerGroups(Collections.singletonList(consumerGroupId.asString())).all().get()).values().stream().findFirst();
        return description.map(d -> this.getKafkaConsumerGroup(topicPartitionOffsets, (ConsumerGroupDescription)d));
    }

    private ConsumerGroup getKafkaConsumerGroup(Map<org.apache.kafka.common.TopicPartition, OffsetAndMetadata> topicPartitionOffsets, ConsumerGroupDescription description) {
        Set groupMembers = description.members().stream().map(member -> this.getKafkaConsumerGroupMember(topicPartitionOffsets, (MemberDescription)member)).collect(Collectors.toSet());
        return new ConsumerGroup(description.groupId(), description.state().toString(), groupMembers);
    }

    private ConsumerGroupMember getKafkaConsumerGroupMember(Map<org.apache.kafka.common.TopicPartition, OffsetAndMetadata> topicPartitionOffsets, MemberDescription member) {
        Set kafkaTopicPartitions = member.assignment().topicPartitions().stream().map(topicPartition -> {
            Optional offset = Optional.ofNullable(topicPartitionOffsets.get(topicPartition));
            return new TopicPartition(topicPartition.partition(), topicPartition.topic(), offset.map(OffsetAndMetadata::offset).orElse(0L).longValue(), this.logEndOffsetChecker.check((org.apache.kafka.common.TopicPartition)topicPartition), offset.map(OffsetAndMetadata::metadata).orElse(""));
        }).collect(Collectors.toSet());
        return new ConsumerGroupMember(member.consumerId(), member.clientId(), member.host(), kafkaTopicPartitions);
    }
}

