/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.ApplicationPath;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.management.api.CORSFilter;
import pl.allegro.tech.hermes.management.api.auth.AllowAllSecurityContextProvider;
import pl.allegro.tech.hermes.management.api.auth.AuthorizationFilter;
import pl.allegro.tech.hermes.management.api.auth.SecurityContextProvider;
import pl.allegro.tech.hermes.management.config.ObjectMapperContextResolver;

@Configuration
@ApplicationPath(value="/")
public class EndpointConfiguration
extends ResourceConfig {
    @Autowired
    ObjectMapper objectMapper;

    public EndpointConfiguration() {
        this.packages(true, new String[]{"pl.allegro.tech.hermes.management.api"});
        this.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", true);
        this.register(ObjectMapperContextResolver.class);
        this.register(AuthorizationFilter.class);
        this.register(CORSFilter.class);
        this.register(RolesAllowedDynamicFeature.class);
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityContextProvider.class})
    SecurityContextProvider authorization() {
        return new AllowAllSecurityContextProvider();
    }
}

