/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.topic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.management.domain.topic.InvalidSchemaException;

@Component
public class SchemaValidator {
    private static final Logger logger = LoggerFactory.getLogger(SchemaValidator.class);
    private final JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.byDefault();
    private final ObjectMapper objectMapper;

    @Autowired
    public SchemaValidator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void check(String schema) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schema) ? 1 : 0) != 0, (Object)"Message schema cannot be empty");
        ArrayList<String> errors = new ArrayList<String>();
        try {
            JsonNode schemaNode = this.objectMapper.readTree(schema);
            ProcessingReport report = this.jsonSchemaFactory.getSyntaxValidator().validateSchema(schemaNode);
            StreamSupport.stream(report.spliterator(), false).forEach(e -> errors.add(e.getMessage()));
        }
        catch (IOException e2) {
            logger.warn("Exception occurred while validating schema", (Throwable)e2);
            throw new InvalidSchemaException(e2);
        }
        if (!errors.isEmpty()) {
            throw new InvalidSchemaException(errors);
        }
    }
}

