/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service.retransmit;

import com.google.common.collect.Range;
import java.util.Optional;
import pl.allegro.tech.hermes.management.infrastructure.kafka.service.retransmit.KafkaTimestampExtractor;

class OffsetSearcher {
    private final KafkaTimestampExtractor timestampExtractor;

    OffsetSearcher(KafkaTimestampExtractor timestampExtractor) {
        this.timestampExtractor = timestampExtractor;
    }

    long search(Range<Long> offsetRange, long timestamp) {
        long left = (Long)offsetRange.lowerEndpoint() - 1L;
        long right = (Long)offsetRange.upperEndpoint();
        while (left + 1L < right) {
            long half = (left + right) / 2L;
            Optional<Long> extractedTimestamp = this.timestampExtractor.extract(half);
            if (!extractedTimestamp.isPresent() || timestamp > extractedTimestamp.get()) {
                left = half;
                continue;
            }
            right = half;
        }
        return right;
    }
}

