/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.MessageTrace;
import pl.allegro.tech.hermes.api.PublishedMessageTrace;
import pl.allegro.tech.hermes.api.PublishedMessageTraceStatus;
import pl.allegro.tech.hermes.api.SentMessageTrace;
import pl.allegro.tech.hermes.api.SentMessageTraceStatus;
import pl.allegro.tech.hermes.common.message.tracker.LogSchemaAware;
import pl.allegro.tech.hermes.management.domain.subscription.LogRepository;

@Component
public class MongoLogRepository
implements LogRepository,
LogSchemaAware {
    private final DB database;

    @Autowired
    public MongoLogRepository(DB database) {
        this.database = database;
    }

    @Override
    public List<SentMessageTrace> getLastUndeliveredMessages(String topicName, String subscriptionName, int limit) {
        try (DBCursor cursor = this.database.getCollection("sent_messages").find((DBObject)new BasicDBObject("topicName", (Object)topicName).append("subscription", (Object)subscriptionName).append("status", (Object)SentMessageTraceStatus.DISCARDED.toString())).sort((DBObject)new BasicDBObject("timestamp", (Object)-1)).limit(limit);){
            List<SentMessageTrace> list = StreamSupport.stream(cursor.spliterator(), false).map(this::convertToSentMessage).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<MessageTrace> getMessageStatus(String qualifiedTopicName, String subscriptionName, String messageId) {
        DBCursor publishedCursor = this.database.getCollection("published_messages").find((DBObject)new BasicDBObject("messageId", (Object)messageId)).sort((DBObject)new BasicDBObject("timestamp", (Object)1));
        DBCursor sentCursor = this.database.getCollection("sent_messages").find((DBObject)new BasicDBObject("messageId", (Object)messageId).append("subscription", (Object)subscriptionName)).sort((DBObject)new BasicDBObject("timestamp", (Object)1));
        return Stream.concat(StreamSupport.stream(publishedCursor.spliterator(), false).map(this::convertToPublishedMessage), StreamSupport.stream(sentCursor.spliterator(), false).map(this::convertToSentMessage)).collect(Collectors.toList());
    }

    private SentMessageTrace convertToSentMessage(DBObject rawObject) {
        BasicDBObject object = (BasicDBObject)rawObject;
        return new SentMessageTrace(object.getString("messageId"), Long.valueOf(object.getLong("timestamp")), object.getString("subscription"), object.getString("topicName"), SentMessageTraceStatus.valueOf((String)object.getString("status")), object.getString("reason"), null, Integer.valueOf(object.getInt("partition", -1)), Long.valueOf(object.getLong("offset", -1L)), object.getString("cluster", ""));
    }

    private PublishedMessageTrace convertToPublishedMessage(DBObject rawObject) {
        BasicDBObject object = (BasicDBObject)rawObject;
        return new PublishedMessageTrace(object.getString("messageId"), Long.valueOf(object.getLong("timestamp")), object.getString("topicName"), PublishedMessageTraceStatus.valueOf((String)object.getString("status")), object.getString("reason"), null, object.getString("cluster", ""));
    }
}

