/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.common.admin.AdminTool;
import pl.allegro.tech.hermes.common.admin.zookeeper.ZookeeperAdminTool;
import pl.allegro.tech.hermes.common.config.Configs;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;
import pl.allegro.tech.hermes.common.message.undelivered.ZookeeperUndeliveredMessageLog;
import pl.allegro.tech.hermes.domain.group.GroupRepository;
import pl.allegro.tech.hermes.domain.subscription.SubscriptionRepository;
import pl.allegro.tech.hermes.domain.subscription.offset.SubscriptionOffsetChangeIndicator;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperGroupRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperSubscriptionOffsetChangeIndicator;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperSubscriptionRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperTopicRepository;
import pl.allegro.tech.hermes.infrastructure.zookeeper.counter.DistributedEphemeralCounter;
import pl.allegro.tech.hermes.infrastructure.zookeeper.counter.SharedCounter;
import pl.allegro.tech.hermes.management.config.StorageProperties;

@Configuration
@EnableConfigurationProperties(value={StorageProperties.class})
public class StorageConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(StorageConfiguration.class);
    @Autowired
    StorageProperties storageProperties;
    @Autowired
    ObjectMapper objectMapper;

    @Bean(name={"storageZookeeper"})
    CuratorFramework storageZookeeper() {
        CuratorFramework curator = CuratorFrameworkFactory.builder().connectString(this.storageProperties.getConnectionString()).sessionTimeoutMs(this.storageProperties.getSessionTimeout()).connectionTimeoutMs(this.storageProperties.getConnectTimeout()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(this.storageProperties.getRetrySleep(), this.storageProperties.getRetryTimes())).build();
        this.startAndWaitForConnection(curator);
        return curator;
    }

    private void startAndWaitForConnection(CuratorFramework curator) {
        curator.start();
        try {
            curator.blockUntilConnected();
        }
        catch (InterruptedException interruptedException) {
            InternalProcessingException exception = new InternalProcessingException("Could not start curator for storage", (Throwable)interruptedException);
            logger.error(exception.getMessage(), (Throwable)interruptedException);
            throw exception;
        }
    }

    @Bean
    ZookeeperPaths zookeeperPaths() {
        return new ZookeeperPaths(this.storageProperties.getPathPrefix());
    }

    @Bean
    public SharedCounter sharedCounter() {
        return new SharedCounter(this.storageZookeeper(), this.storageProperties.getSharedCountersExpiration(), this.storageProperties.getRetrySleep(), this.storageProperties.getRetryTimes());
    }

    @Bean
    public DistributedEphemeralCounter distributedCounter() {
        return new DistributedEphemeralCounter(this.storageZookeeper());
    }

    @Bean
    GroupRepository groupRepository() {
        return new ZookeeperGroupRepository(this.storageZookeeper(), this.objectMapper, this.zookeeperPaths());
    }

    @Bean
    TopicRepository topicRepository() {
        return new ZookeeperTopicRepository(this.storageZookeeper(), this.objectMapper, this.zookeeperPaths(), this.groupRepository());
    }

    @Bean
    SubscriptionRepository subscriptionRepository() {
        return new ZookeeperSubscriptionRepository(this.storageZookeeper(), this.objectMapper, this.zookeeperPaths(), this.topicRepository());
    }

    @Bean
    SubscriptionOffsetChangeIndicator subscriptionOffsetChangeIndicator() {
        return new ZookeeperSubscriptionOffsetChangeIndicator(this.storageZookeeper(), this.zookeeperPaths(), this.subscriptionRepository());
    }

    @Bean
    AdminTool adminTool() {
        return new ZookeeperAdminTool(this.storageZookeeper(), this.objectMapper, ((Integer)Configs.ADMIN_REAPER_INTERAL_MS.getDefaultValue()).intValue());
    }

    @Bean
    UndeliveredMessageLog undeliveredMessageLog() {
        return new ZookeeperUndeliveredMessageLog(this.storageZookeeper(), this.zookeeperPaths(), this.objectMapper);
    }
}

