/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query.parser;

import java.util.Arrays;
import java.util.Optional;

public enum Operator {
    EQ("eq"),
    NE("ne"),
    LIKE("like"),
    IN("in"),
    NOT("not"),
    AND("and"),
    OR("or");

    private String name;

    private Operator(String name) {
        this.name = name;
    }

    public static Operator from(String name) {
        return Operator.fromOptional(name).orElseThrow(() -> new IllegalArgumentException(String.format("No operator matching '%s' could be found", name)));
    }

    public static boolean isValid(String name) {
        return Operator.fromOptional(name).isPresent();
    }

    private static Optional<Operator> fromOptional(String name) {
        return Arrays.stream(Operator.values()).filter(value -> value.name.equalsIgnoreCase(name)).findFirst();
    }
}

