/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.oauth;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.OAuthProvider;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.api.helpers.Patch;
import pl.allegro.tech.hermes.domain.oauth.OAuthProviderRepository;
import pl.allegro.tech.hermes.management.api.validator.ApiPreconditions;

@Component
public class OAuthProviderService {
    private final OAuthProviderRepository repository;
    private final ApiPreconditions preconditions;

    @Autowired
    public OAuthProviderService(OAuthProviderRepository repository, ApiPreconditions preconditions) {
        this.repository = repository;
        this.preconditions = preconditions;
    }

    public List<String> listOAuthProviderNames() {
        return this.repository.listOAuthProviderNames();
    }

    public OAuthProvider getOAuthProviderDetails(String oAuthProviderName) {
        return this.repository.getOAuthProviderDetails(oAuthProviderName).anonymize();
    }

    public void createOAuthProvider(OAuthProvider oAuthProvider) {
        this.preconditions.checkConstraints(oAuthProvider);
        this.repository.createOAuthProvider(oAuthProvider);
    }

    public void removeOAuthProvider(String oAuthProviderName) {
        this.repository.removeOAuthProvider(oAuthProviderName);
    }

    public void updateOAuthProvider(String oAuthProviderName, PatchData patch) {
        OAuthProvider retrieved = this.repository.getOAuthProviderDetails(oAuthProviderName);
        OAuthProvider updated = (OAuthProvider)Patch.apply((Object)retrieved, (PatchData)patch);
        this.preconditions.checkConstraints(updated);
        this.repository.updateOAuthProvider(updated);
    }
}

