/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.schema;

import org.apache.curator.framework.CuratorFramework;
import pl.allegro.tech.hermes.api.SchemaSource;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.domain.topic.schema.ZookeeperSchemaSourceProvider;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.management.domain.topic.schema.CouldNotDeleteSchemaException;
import pl.allegro.tech.hermes.management.domain.topic.schema.CouldNotSaveSchemaException;
import pl.allegro.tech.hermes.management.domain.topic.schema.SchemaSourceRepository;

public class ZookeeperSchemaSourceRepository
extends ZookeeperSchemaSourceProvider
implements SchemaSourceRepository {
    public ZookeeperSchemaSourceRepository(CuratorFramework curatorFramework, ZookeeperPaths zkPaths) {
        super(curatorFramework, zkPaths);
    }

    @Override
    public void save(SchemaSource schemaSource, Topic topic) {
        try {
            String schemaPath = this.zkPaths.topicPath(topic.getName(), new String[]{"schema"});
            byte[] schema = schemaSource.value().getBytes();
            if (this.curatorFramework.checkExists().forPath(schemaPath) == null) {
                this.curatorFramework.create().creatingParentsIfNeeded().forPath(schemaPath, schema);
            } else {
                this.curatorFramework.setData().forPath(schemaPath, schema);
            }
        }
        catch (Exception e) {
            throw new CouldNotSaveSchemaException("Could not store in zookeeper schema for topic " + topic.getQualifiedName(), e);
        }
    }

    @Override
    public void delete(Topic topic) {
        try {
            this.curatorFramework.delete().forPath(this.zkPaths.topicPath(topic.getName(), new String[]{"schema"}));
        }
        catch (Exception e) {
            throw new CouldNotDeleteSchemaException("Could not delete from zookeeper schema for topic " + topic.getQualifiedName(), e);
        }
    }
}

