/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.client.ClientBuilder;
import org.apache.avro.Schema;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaRepository;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaSourceProvider;
import pl.allegro.tech.hermes.infrastructure.schema.repo.JerseySchemaRepoClient;
import pl.allegro.tech.hermes.infrastructure.schema.repo.SchemaRepoClient;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.management.config.SchemaCacheProperties;
import pl.allegro.tech.hermes.management.config.SchemaRepositoryProperties;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.management.domain.topic.schema.SchemaSourceRepository;
import pl.allegro.tech.hermes.management.domain.topic.schema.TopicFieldSchemaSourceRepository;
import pl.allegro.tech.hermes.management.infrastructure.schema.SchemaRepoSchemaSourceRepository;
import pl.allegro.tech.hermes.management.infrastructure.schema.ZookeeperSchemaSourceRepository;

@Configuration
@EnableConfigurationProperties(value={SchemaRepositoryProperties.class, SchemaCacheProperties.class})
public class SchemaRepositoryConfiguration {
    @Autowired
    SchemaCacheProperties schemaCacheProperties;
    @Autowired
    @Lazy
    TopicService topicService;
    @Autowired
    @Lazy
    private CuratorFramework storageZookeeper;
    @Autowired
    @Lazy
    private ZookeeperPaths zookeeperPaths;
    @Autowired
    private SchemaRepositoryProperties schemaRepositoryProperties;

    @Bean
    @ConditionalOnMissingBean(value={SchemaSourceRepository.class})
    @ConditionalOnProperty(value={"schema.repository.type"}, havingValue="zookeeper", matchIfMissing=true)
    public SchemaSourceRepository zookeeperSchemaSourceRepository() {
        return new ZookeeperSchemaSourceRepository(this.storageZookeeper, this.zookeeperPaths);
    }

    @Bean
    @ConditionalOnMissingBean(value={SchemaSourceRepository.class})
    @ConditionalOnProperty(value={"schema.repository.type"}, havingValue="schema_repo")
    public SchemaSourceRepository schemaRepoSchemaSourceRepository() {
        JerseySchemaRepoClient client = new JerseySchemaRepoClient(ClientBuilder.newClient(), URI.create(this.schemaRepositoryProperties.getServerUrl()));
        return new SchemaRepoSchemaSourceRepository((SchemaRepoClient)client);
    }

    @Bean
    @ConditionalOnMissingBean(value={SchemaSourceRepository.class})
    @ConditionalOnProperty(value={"schema.repository.type"}, havingValue="topic_field")
    public SchemaSourceRepository topicFieldSchemaSourceRepository() {
        return new TopicFieldSchemaSourceRepository(this.topicService);
    }

    @Bean
    public SchemaRepository<Schema> avroSchemaRepository(SchemaSourceRepository schemaSourceRepository) {
        return new SchemaRepository((SchemaSourceProvider)schemaSourceRepository, this.createSchemaReloadExecutorService(this.schemaCacheProperties.getPoolSize(), "avro"), this.schemaCacheProperties.getRefreshAfterWriteMinutes(), this.schemaCacheProperties.getExpireAfterWriteMinutes(), source -> new Schema.Parser().parse(source.value()));
    }

    private ExecutorService createSchemaReloadExecutorService(int poolSize, String format) {
        return Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setNameFormat(format + "-schema-reloader-%d").build());
    }
}

