/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.topic;

import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicMetrics;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.api.helpers.Patch;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.config.TopicProperties;
import pl.allegro.tech.hermes.management.domain.group.GroupService;
import pl.allegro.tech.hermes.management.domain.topic.TopicContentTypeMigrationService;
import pl.allegro.tech.hermes.management.domain.topic.TopicMetricsRepository;
import pl.allegro.tech.hermes.management.domain.topic.TopicRemovalDisabledException;
import pl.allegro.tech.hermes.management.domain.topic.validator.TopicValidator;
import pl.allegro.tech.hermes.management.infrastructure.kafka.MultiDCAwareService;

@Component
public class TopicService {
    private static final Logger logger = LoggerFactory.getLogger(TopicService.class);
    private final boolean allowRemoval;
    private final TopicRepository topicRepository;
    private final GroupService groupService;
    private final TopicMetricsRepository metricRepository;
    private final MultiDCAwareService multiDCAwareService;
    private final TopicValidator topicValidator;
    private final TopicContentTypeMigrationService topicContentTypeMigrationService;
    private final Clock clock;

    @Inject
    public TopicService(MultiDCAwareService multiDCAwareService, TopicRepository topicRepository, GroupService groupService, TopicProperties topicProperties, TopicMetricsRepository metricRepository, TopicValidator topicValidator, TopicContentTypeMigrationService topicContentTypeMigrationService, Clock clock) {
        this.multiDCAwareService = multiDCAwareService;
        this.allowRemoval = topicProperties.isAllowRemoval();
        this.topicRepository = topicRepository;
        this.groupService = groupService;
        this.metricRepository = metricRepository;
        this.topicValidator = topicValidator;
        this.topicContentTypeMigrationService = topicContentTypeMigrationService;
        this.clock = clock;
    }

    public void createTopic(Topic topic) {
        this.topicValidator.ensureCreatedTopicIsValid(topic);
        this.topicRepository.createTopic(topic);
        try {
            this.multiDCAwareService.manageTopic(brokerTopicManagement -> brokerTopicManagement.createTopic(topic));
        }
        catch (Exception exception) {
            logger.error(String.format("Could not create topic %s, rollback topic creation.", topic.getQualifiedName()), (Throwable)exception);
            this.topicRepository.removeTopic(topic.getName());
        }
    }

    public void removeTopic(Topic topic) {
        if (!this.allowRemoval) {
            throw new TopicRemovalDisabledException(topic);
        }
        this.topicRepository.removeTopic(topic.getName());
        this.multiDCAwareService.manageTopic(brokerTopicManagement -> brokerTopicManagement.removeTopic(topic));
    }

    public void updateTopic(Topic topic) {
        this.groupService.checkGroupExists(topic.getName().getGroupName());
        Topic retrieved = this.getTopicDetails(topic.getName());
        Topic modified = (Topic)Patch.apply((Object)retrieved, (Object)topic);
        this.topicValidator.ensureUpdatedTopicIsValid(modified, retrieved);
        if (!retrieved.equals((Object)modified)) {
            Instant beforeMigrationInstant = this.clock.instant();
            if (retrieved.getRetentionTime() != modified.getRetentionTime()) {
                this.multiDCAwareService.manageTopic(brokerTopicManagement -> brokerTopicManagement.updateTopic(modified));
            }
            this.topicRepository.updateTopic(modified);
            if (!retrieved.wasMigratedFromJsonType() && modified.wasMigratedFromJsonType()) {
                this.topicContentTypeMigrationService.notifySubscriptions(modified, beforeMigrationInstant);
            }
        }
    }

    public List<String> listQualifiedTopicNames(String groupName) {
        return this.topicRepository.listTopicNames(groupName).stream().map(topicName -> new TopicName(groupName, topicName).qualifiedName()).collect(Collectors.toList());
    }

    public List<String> listQualifiedTopicNames() {
        return this.groupService.listGroups().stream().map(this::listQualifiedTopicNames).flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public List<Topic> listTopics(String groupName) {
        return this.topicRepository.listTopics(groupName);
    }

    public Topic getTopicDetails(TopicName topicName) {
        return this.topicRepository.getTopicDetails(topicName);
    }

    public TopicMetrics getTopicMetrics(TopicName topicName) {
        return this.topicRepository.topicExists(topicName) ? this.metricRepository.loadMetrics(topicName) : TopicMetrics.unavailable();
    }

    public String fetchSingleMessageFromPrimary(String brokersClusterName, TopicName topicName, Integer partition, Long offset) {
        return this.multiDCAwareService.readMessageFromPrimary(brokersClusterName, this.getTopicDetails(topicName), partition, offset);
    }

    public List<String> listTrackedTopicNames() {
        return this.groupService.listGroups().stream().map(arg_0 -> ((TopicRepository)this.topicRepository).listTopics(arg_0)).flatMap(Collection::stream).filter(Topic::isTrackingEnabled).map(Topic::getQualifiedName).collect(Collectors.toList());
    }

    public List<String> listTrackedTopicNames(String groupName) {
        return this.listTopics(groupName).stream().filter(Topic::isTrackingEnabled).map(Topic::getQualifiedName).collect(Collectors.toList());
    }
}

