/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.graphite;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteMetrics;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteResponse;

public class GraphiteClient {
    private static final Logger logger = LoggerFactory.getLogger(GraphiteClient.class);
    private static final String DEFAULT_VALUE = "0.0";
    private static final String TARGET_PARAM = "target";
    private final WebTarget webTarget;

    public GraphiteClient(WebTarget webTarget) {
        this.webTarget = webTarget.path("render").queryParam("from", new Object[]{"-1minutes"}).queryParam("until", new Object[]{"now"}).queryParam("format", new Object[]{"json"});
    }

    public GraphiteMetrics readMetrics(String ... metrics) {
        try {
            GraphiteMetrics response = new GraphiteMetrics();
            this.queryGraphite(metrics).stream().forEach(metric -> response.addMetricValue(metric.getTarget(), this.getFirstValue((GraphiteResponse)metric)));
            return response;
        }
        catch (Exception exception) {
            logger.warn("Unable to read from Graphite. {}", (Object)ExceptionUtils.getRootCause((Throwable)exception).getMessage());
            return GraphiteMetrics.unavailable(metrics);
        }
    }

    private String getFirstValue(GraphiteResponse graphiteResponse) {
        Preconditions.checkArgument((boolean)this.hasDatapoints(graphiteResponse), (Object)"Graphite format changed. Reexamine implementation.");
        String value = graphiteResponse.getDatapoints().get(0).get(0);
        return Strings.isNullOrEmpty((String)value) || "null".equals(value) ? DEFAULT_VALUE : value;
    }

    private boolean hasDatapoints(GraphiteResponse graphiteResponse) {
        return !graphiteResponse.getDatapoints().isEmpty() && !graphiteResponse.getDatapoints().get(0).isEmpty();
    }

    private List<GraphiteResponse> queryGraphite(String ... queries) {
        WebTarget webQuery = this.webTarget;
        for (String query : queries) {
            webQuery = webQuery.queryParam(TARGET_PARAM, new Object[]{query});
        }
        return (List)webQuery.request(new String[]{"application/json"}).get().readEntity((GenericType)new GraphiteResponseList());
    }

    protected static class GraphiteResponseList
    extends GenericType<List<GraphiteResponse>> {
        protected GraphiteResponseList() {
        }
    }
}

