/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils;
import kafka.log.LogConfig;
import org.I0Itec.zkclient.ZkClient;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.common.kafka.KafkaNamesMapper;
import pl.allegro.tech.hermes.common.kafka.KafkaTopics;
import pl.allegro.tech.hermes.management.config.TopicProperties;
import pl.allegro.tech.hermes.management.domain.topic.BrokerTopicManagement;

public class KafkaBrokerTopicManagement
implements BrokerTopicManagement {
    private final TopicProperties topicProperties;
    private final ZkClient client;
    private final KafkaNamesMapper kafkaNamesMapper;

    public KafkaBrokerTopicManagement(TopicProperties topicProperties, ZkClient zkClient, KafkaNamesMapper kafkaNamesMapper) {
        this.topicProperties = topicProperties;
        this.client = zkClient;
        this.kafkaNamesMapper = kafkaNamesMapper;
    }

    @Override
    public void createTopic(Topic topic) {
        Properties config = this.createTopicConfig(topic.getRetentionTime().getDuration(), this.topicProperties);
        this.kafkaNamesMapper.toKafkaTopics(topic).forEach(k -> AdminUtils.createTopic((ZkClient)this.client, (String)k.name().asString(), (int)this.topicProperties.getPartitions(), (int)this.topicProperties.getReplicationFactor(), (Properties)config));
    }

    @Override
    public void removeTopic(Topic topic) {
        this.kafkaNamesMapper.toKafkaTopics(topic).forEach(k -> AdminUtils.deleteTopic((ZkClient)this.client, (String)k.name().asString()));
    }

    @Override
    public void updateTopic(Topic topic) {
        Properties config = this.createTopicConfig(topic.getRetentionTime().getDuration(), this.topicProperties);
        KafkaTopics kafkaTopics = this.kafkaNamesMapper.toKafkaTopics(topic);
        if (this.isMigrationToNewKafkaTopic(kafkaTopics)) {
            AdminUtils.createTopic((ZkClient)this.client, (String)kafkaTopics.getPrimary().name().asString(), (int)this.topicProperties.getPartitions(), (int)this.topicProperties.getReplicationFactor(), (Properties)config);
        } else {
            AdminUtils.changeTopicConfig((ZkClient)this.client, (String)kafkaTopics.getPrimary().name().asString(), (Properties)config);
        }
        kafkaTopics.getSecondary().ifPresent(secondary -> AdminUtils.changeTopicConfig((ZkClient)this.client, (String)secondary.name().asString(), (Properties)config));
    }

    protected boolean isMigrationToNewKafkaTopic(KafkaTopics kafkaTopics) {
        return kafkaTopics.getSecondary().isPresent() && !AdminUtils.topicExists((ZkClient)this.client, (String)kafkaTopics.getPrimary().name().asString());
    }

    private Properties createTopicConfig(int retentionPolicy, TopicProperties topicProperties) {
        Properties props = new Properties();
        props.put(LogConfig.RententionMsProp(), String.valueOf(TimeUnit.DAYS.toMillis(retentionPolicy)));
        props.put(LogConfig.UncleanLeaderElectionEnableProp(), Boolean.toString(topicProperties.isUncleanLeaderElectionEnabled()));
        return props;
    }
}

