/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.spring;

import com.google.common.collect.Lists;
import java.util.List;
import joptsimple.OptionParser;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.JOptCommandLinePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class CommandLinePropertiesApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final String ENVIRONMENT_PROPERTY = "application.environment";
    public static final String SERVER_PORT_PROPERTY = "server.port";

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        propertySources.addFirst(this.cmdLinePropertySource(event.getArgs()));
        String environmentName = environment.getProperty(ENVIRONMENT_PROPERTY);
        environment.addActiveProfile(environmentName);
    }

    private PropertySource<?> cmdLinePropertySource(String[] args) {
        OptionParser parser = new OptionParser();
        parser.acceptsAll((List)Lists.newArrayList((Object[])new String[]{ENVIRONMENT_PROPERTY, "environment", "e"})).withRequiredArg().defaultsTo((Object)"local", (Object[])new String[0]);
        parser.acceptsAll((List)Lists.newArrayList((Object[])new String[]{SERVER_PORT_PROPERTY, "port", "p"})).withRequiredArg();
        parser.allowsUnrecognizedOptions();
        return new JOptCommandLinePropertySource(parser.parse(args));
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

