/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import com.wordnik.swagger.annotations.ApiOperation;
import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.api.SchemaSource;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.management.domain.topic.schema.SchemaSourceService;

@Path(value="topics/{topicName}/schema")
public class SchemaEndpoint {
    private final SchemaSourceService schemaSourceService;
    private final TopicService topicService;

    @Autowired
    public SchemaEndpoint(SchemaSourceService schemaSourceService, TopicService topicService) {
        this.schemaSourceService = schemaSourceService;
        this.topicService = topicService;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get schema", httpMethod="GET")
    public Response get(@PathParam(value="topicName") String qualifiedTopicName) {
        Optional<SchemaSource> schemaSource = this.schemaSourceService.getSchemaSource(qualifiedTopicName);
        return schemaSource.map(SchemaSource::value).map(v -> Response.ok((Object)v).build()).orElse(Response.noContent().build());
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"groupOwner", "admin"})
    @ApiOperation(value="Save schema", httpMethod="POST")
    public Response save(@PathParam(value="topicName") String qualifiedTopicName, @DefaultValue(value="true") @QueryParam(value="validate") boolean validate, String schema) {
        this.schemaSourceService.saveSchemaSource(qualifiedTopicName, schema, validate);
        this.notifyFrontendSchemaChanged(qualifiedTopicName);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private void notifyFrontendSchemaChanged(String qualifiedTopicName) {
        this.topicService.touchTopic(TopicName.fromQualifiedName((String)qualifiedTopicName));
    }

    @DELETE
    @RolesAllowed(value={"groupOwner", "admin"})
    @ApiOperation(value="Delete schema", httpMethod="DELETE")
    public Response delete(@PathParam(value="topicName") String qualifiedTopicName) {
        this.schemaSourceService.deleteSchemaSource(qualifiedTopicName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

