/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import org.apache.avro.Schema;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.common.message.wrapper.AvroMessageContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.JsonMessageContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.MessageContentWrapper;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaRepository;
import pl.allegro.tech.hermes.management.config.MessageProperties;

@Configuration
@EnableConfigurationProperties(value={MessageProperties.class})
public class MessageConfiguration {
    @Autowired
    MessageProperties messageProperties;
    @Autowired
    SchemaRepository<Schema> avroSchemaRepository;
    @Autowired
    Clock clock;

    @Bean
    ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    MessageContentWrapper messageContentWrapper() {
        return new MessageContentWrapper(this.jsonMessageContentWrapper(), new AvroMessageContentWrapper(this.clock), this.avroSchemaRepository);
    }

    private JsonMessageContentWrapper jsonMessageContentWrapper() {
        return new JsonMessageContentWrapper(this.messageProperties.getContentRoot(), this.messageProperties.getMetadataContentRoot(), this.objectMapper());
    }
}

