/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.topic.schema;

import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.SchemaSource;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.management.domain.topic.schema.AvroSchemaRemovalDisabledException;
import pl.allegro.tech.hermes.management.domain.topic.schema.SchemaSourceRepository;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.SchemaValidator;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.SchemaValidatorProvider;

@Component
public class SchemaSourceService {
    private final TopicService topicService;
    private final SchemaSourceRepository schemaSourceRepository;
    private final SchemaValidatorProvider validatorProvider;

    @Autowired
    public SchemaSourceService(TopicService topicService, SchemaSourceRepository schemaSourceRepository, SchemaValidatorProvider validatorProvider) {
        this.topicService = topicService;
        this.schemaSourceRepository = schemaSourceRepository;
        this.validatorProvider = validatorProvider;
    }

    public Optional<SchemaSource> getSchemaSource(String qualifiedTopicName) {
        Topic topic = this.findTopic(qualifiedTopicName);
        return this.schemaSourceRepository.get(topic);
    }

    public void saveSchemaSource(String qualifiedTopicName, String schema, boolean validate) {
        Topic topic = this.findTopic(qualifiedTopicName);
        if (validate) {
            SchemaValidator validator = this.validatorProvider.provide(topic.getContentType());
            validator.check(schema);
        }
        this.schemaSourceRepository.save(SchemaSource.valueOf((String)schema), topic);
    }

    public void deleteSchemaSource(String qualifiedTopicName) {
        Topic topic = this.findTopic(qualifiedTopicName);
        if (topic.getContentType() == Topic.ContentType.AVRO) {
            throw new AvroSchemaRemovalDisabledException("Topic " + qualifiedTopicName + " has Avro content-type, schema removal is disabled");
        }
        this.schemaSourceRepository.delete(topic);
    }

    private Topic findTopic(String qualifiedTopicName) {
        return this.topicService.getTopicDetails(TopicName.fromQualifiedName((String)qualifiedTopicName));
    }
}

