/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query.matcher;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumMap;
import java.util.Map;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.AndMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.EqualityMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.InMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.Matcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherFactory;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherNotFoundException;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.NotMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.OrMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.parser.Operator;
import pl.allegro.tech.hermes.management.infrastructure.query.parser.QueryParserContext;

public class MatcherFactories {
    private static final Map<Operator, MatcherFactory> FACTORIES = new EnumMap<Operator, MatcherFactory>(Operator.class);

    public static MatcherFactory getMatcherFactory(String operator) {
        try {
            return MatcherFactories.getMatcherFactory(Operator.from(operator));
        }
        catch (IllegalArgumentException e) {
            throw new MatcherNotFoundException(String.format("Unrecognized operator: '%s'", operator));
        }
    }

    public static MatcherFactory defaultMatcher() {
        return MatcherFactories.getMatcherFactory(Operator.EQ);
    }

    private static MatcherFactory getMatcherFactory(Operator operator) {
        return FACTORIES.get((Object)operator);
    }

    private static void registerFactories() {
        FACTORIES.put(Operator.EQ, new MatcherFactory(){

            @Override
            public <T> Matcher<T> createMatcher(String path, JsonNode node, QueryParserContext parser) {
                return new EqualityMatcher(path, parser.parseValue(node));
            }
        });
        FACTORIES.put(Operator.NE, new MatcherFactory(){

            @Override
            public <T> Matcher<T> createMatcher(String path, JsonNode node, QueryParserContext parser) {
                return new NotMatcher(new EqualityMatcher(path, parser.parseValue(node)));
            }
        });
        FACTORIES.put(Operator.IN, new MatcherFactory(){

            @Override
            public <T> Matcher<T> createMatcher(String path, JsonNode node, QueryParserContext parser) {
                return new InMatcher(path, parser.parseArrayValue(node));
            }
        });
        FACTORIES.put(Operator.NOT, new MatcherFactory(){

            @Override
            public <T> Matcher<T> createMatcher(String path, JsonNode node, QueryParserContext parser) {
                return new NotMatcher(parser.parseNode(node));
            }
        });
        FACTORIES.put(Operator.AND, new MatcherFactory(){

            @Override
            public <T> Matcher<T> createMatcher(String path, JsonNode node, QueryParserContext parser) {
                return new AndMatcher(parser.parseArrayNodes(node));
            }
        });
        FACTORIES.put(Operator.OR, new MatcherFactory(){

            @Override
            public <T> Matcher<T> createMatcher(String path, JsonNode node, QueryParserContext parser) {
                return new OrMatcher(parser.parseArrayNodes(node));
            }
        });
    }

    static {
        MatcherFactories.registerFactories();
    }
}

