/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query.parser.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import pl.allegro.tech.hermes.common.query.Query;
import pl.allegro.tech.hermes.management.infrastructure.query.MatcherQuery;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.AndMatcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.Matcher;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherFactories;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.MatcherNotFoundException;
import pl.allegro.tech.hermes.management.infrastructure.query.parser.Operator;
import pl.allegro.tech.hermes.management.infrastructure.query.parser.ParseException;
import pl.allegro.tech.hermes.management.infrastructure.query.parser.QueryParser;
import pl.allegro.tech.hermes.management.infrastructure.query.parser.QueryParserContext;
import pl.allegro.tech.hermes.management.infrastructure.utils.Iterators;

public class JsonQueryParser
implements QueryParser,
QueryParserContext {
    private static final String QUERY = "query";
    private final ObjectMapper objectMapper;

    public JsonQueryParser(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> Query<T> parse(InputStream input, Class<T> type) {
        try {
            return this.parseDocument(this.objectMapper.readTree(input));
        }
        catch (IOException | MatcherNotFoundException e) {
            throw new ParseException("Query could not be parsed", e);
        }
    }

    @Override
    public <T> Query<T> parse(String query, Class<T> type) {
        return this.parse(new ByteArrayInputStream(query.getBytes()), type);
    }

    @Override
    public <T> Matcher<T> parseNode(JsonNode node) {
        Map.Entry<String, JsonNode> entry = this.singleNode(node);
        return this.parseSingleAttribute(entry.getKey(), entry.getValue());
    }

    @Override
    public <T> List<Matcher<T>> parseArrayNodes(JsonNode node) {
        if (!node.isArray()) {
            throw new ParseException("Element value was expected to be an array");
        }
        return this.parseObjectArray(node);
    }

    @Override
    public Object parseValue(JsonNode node) {
        if (!node.isValueNode()) {
            throw new ParseException("The node value wasn't present");
        }
        if (node.isTextual()) {
            return node.asText();
        }
        if (node.isInt()) {
            return node.asInt();
        }
        if (node.isDouble()) {
            return node.asDouble();
        }
        return null;
    }

    @Override
    public Object[] parseArrayValue(JsonNode node) {
        if (!node.isArray()) {
            throw new ParseException("Element value was expected to be an array");
        }
        return StreamSupport.stream(node.spliterator(), false).map(this::parseValue).toArray();
    }

    private <T> Query<T> parseDocument(JsonNode document) {
        this.validateDocument(document);
        return this.parseQuery(document.get(QUERY));
    }

    private <T> Query<T> parseQuery(JsonNode node) {
        return MatcherQuery.fromMatcher(this.parseCompoundObject(node));
    }

    private <T> Matcher<T> parseCompoundObject(JsonNode node) {
        return new AndMatcher<T>(this.parseAllAttributes(node));
    }

    private <T> Matcher<T> parseSingleAttribute(String key, JsonNode node) {
        if (this.isOperator(key)) {
            return this.parseOperator(key, node);
        }
        if (node.isObject()) {
            return this.parseObject(key, node);
        }
        return this.parseAttribute(key, node);
    }

    private <T> List<Matcher<T>> parseAllAttributes(JsonNode node) {
        return Iterators.stream(node.fields()).map(entry -> this.parseSingleAttribute((String)entry.getKey(), (JsonNode)entry.getValue())).collect(Collectors.toList());
    }

    private <T> Matcher<T> parseOperator(String key, JsonNode node) {
        return MatcherFactories.getMatcherFactory(key).createMatcher(key, node, this);
    }

    private <T> Matcher<T> parseObject(String key, JsonNode node) {
        Map.Entry<String, JsonNode> entry = this.singleNode(node);
        return MatcherFactories.getMatcherFactory(entry.getKey()).createMatcher(key, entry.getValue(), this);
    }

    private <T> List<Matcher<T>> parseObjectArray(JsonNode node) {
        return Iterators.stream(node.iterator()).map(this::parseCompoundObject).collect(Collectors.toList());
    }

    private <T> Matcher<T> parseAttribute(String key, JsonNode node) {
        return MatcherFactories.defaultMatcher().createMatcher(key, node, this);
    }

    private boolean isOperator(String key) {
        return Operator.isValid(key);
    }

    private Map.Entry<String, JsonNode> singleNode(JsonNode node) {
        ArrayList attributes = Lists.newArrayList((Iterator)node.fields());
        if (attributes.size() != 1) {
            throw new MatcherNotFoundException(String.format("The object must define exactly one member, but defines %s", Lists.newArrayList((Iterator)node.fieldNames()).toString()));
        }
        return (Map.Entry)attributes.get(0);
    }

    private void validateDocument(JsonNode document) {
        if (!document.isObject() || !document.has(QUERY)) {
            throw new ParseException("JSON object must contain 'query' attribute");
        }
    }
}

