/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service;

import java.nio.charset.Charset;
import org.apache.avro.Schema;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.common.kafka.KafkaTopic;
import pl.allegro.tech.hermes.common.message.serialization.SchemaAwarePayload;
import pl.allegro.tech.hermes.common.message.serialization.SchemaAwareSerDe;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaRepository;
import pl.allegro.tech.hermes.management.domain.topic.SingleMessageReader;
import pl.allegro.tech.hermes.management.infrastructure.kafka.service.KafkaRawMessageReader;
import tech.allegro.schema.json2avro.converter.JsonAvroConverter;

public class KafkaSingleMessageReader
implements SingleMessageReader {
    private final KafkaRawMessageReader kafkaRawMessageReader;
    private final SchemaRepository schemaRepository;
    private final JsonAvroConverter converter;

    public KafkaSingleMessageReader(KafkaRawMessageReader kafkaRawMessageReader, SchemaRepository schemaRepository, JsonAvroConverter converter) {
        this.kafkaRawMessageReader = kafkaRawMessageReader;
        this.schemaRepository = schemaRepository;
        this.converter = converter;
    }

    @Override
    public String readMessageAsJson(Topic topic, KafkaTopic kafkaTopic, int partition, long offset) {
        byte[] bytes = this.kafkaRawMessageReader.readMessage(kafkaTopic, partition, offset);
        if (topic.getContentType() == ContentType.AVRO) {
            bytes = this.convertAvroToJson(topic, bytes);
        }
        return new String(bytes, Charset.forName("UTF-8"));
    }

    private byte[] convertAvroToJson(Topic topic, byte[] bytes) {
        if (topic.isSchemaVersionAwareSerializationEnabled()) {
            SchemaAwarePayload payload = SchemaAwareSerDe.deserialize((byte[])bytes);
            return this.converter.convertToJson(payload.getPayload(), (Schema)this.schemaRepository.getAvroSchema(topic, payload.getSchemaVersion()).getSchema());
        }
        return this.converter.convertToJson(bytes, (Schema)this.schemaRepository.getAvroSchema(topic).getSchema());
    }
}

