/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service;

import java.util.HashMap;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.common.TopicAndPartition;
import kafka.javaapi.OffsetRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.common.broker.BrokerStorage;
import pl.allegro.tech.hermes.common.exception.BrokerNotFoundForPartitionException;
import pl.allegro.tech.hermes.common.exception.PartitionsNotFoundForGivenTopicException;
import pl.allegro.tech.hermes.common.kafka.KafkaTopic;
import pl.allegro.tech.hermes.common.kafka.SimpleConsumerPool;

public class OffsetsAvailableChecker {
    private static final Logger logger = LoggerFactory.getLogger(OffsetsAvailableChecker.class);
    private final SimpleConsumerPool simpleConsumerPool;
    private final BrokerStorage storage;

    public OffsetsAvailableChecker(SimpleConsumerPool simpleConsumerPool, BrokerStorage storage) {
        this.simpleConsumerPool = simpleConsumerPool;
        this.storage = storage;
    }

    public boolean areOffsetsAvailable(KafkaTopic topic) {
        try {
            return this.storage.readPartitionsIds(topic.name().asString()).stream().allMatch(partition -> {
                TopicAndPartition topicAndPartition = new TopicAndPartition(topic.name().asString(), partition.intValue());
                HashMap<TopicAndPartition, PartitionOffsetRequestInfo> requestInfo = new HashMap<TopicAndPartition, PartitionOffsetRequestInfo>();
                requestInfo.put(topicAndPartition, new PartitionOffsetRequestInfo(0L, 1));
                OffsetRequest request = new OffsetRequest(requestInfo, kafka.api.OffsetRequest.CurrentVersion(), "OffsetsAvailableChecker_" + topic.name().asString());
                return !this.simpleConsumerPool.get(topic, partition.intValue()).getOffsetsBefore(request).hasError();
            });
        }
        catch (BrokerNotFoundForPartitionException | PartitionsNotFoundForGivenTopicException e) {
            logger.debug("Offsets reported as not available due to failure", e);
            return false;
        }
    }
}

