/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import javax.ws.rs.client.Client;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import pl.allegro.tech.hermes.domain.topic.schema.CompiledSchemaRepository;
import pl.allegro.tech.hermes.domain.topic.schema.DirectCompiledSchemaRepository;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaCompilersFactory;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaRepository;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaSourceProvider;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaVersionsRepository;
import pl.allegro.tech.hermes.domain.topic.schema.SimpleSchemaVersionsRepository;
import pl.allegro.tech.hermes.infrastructure.schema.repo.JerseySchemaRepoClient;
import pl.allegro.tech.hermes.infrastructure.schema.repo.SchemaRepoClient;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.management.config.SchemaCacheProperties;
import pl.allegro.tech.hermes.management.config.SchemaRepositoryProperties;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.management.domain.topic.schema.SchemaSourceRepository;
import pl.allegro.tech.hermes.management.infrastructure.schema.SchemaRepoSchemaSourceRepository;
import pl.allegro.tech.hermes.management.infrastructure.schema.TopicFieldSchemaSourceRepository;
import pl.allegro.tech.hermes.management.infrastructure.schema.ZookeeperSchemaSourceRepository;

@Configuration
@EnableConfigurationProperties(value={SchemaRepositoryProperties.class, SchemaCacheProperties.class})
public class SchemaRepositoryConfiguration {
    @Autowired
    SchemaCacheProperties schemaCacheProperties;
    @Autowired
    @Lazy
    TopicService topicService;
    @Autowired
    @Lazy
    private CuratorFramework storageZookeeper;
    @Autowired
    @Lazy
    private ZookeeperPaths zookeeperPaths;
    @Autowired
    private SchemaRepositoryProperties schemaRepositoryProperties;

    @Bean
    @ConditionalOnMissingBean(value={SchemaSourceRepository.class})
    @ConditionalOnProperty(value={"schema.repository.type"}, havingValue="zookeeper", matchIfMissing=true)
    public SchemaSourceRepository zookeeperSchemaSourceRepository() {
        return new ZookeeperSchemaSourceRepository(this.storageZookeeper, this.zookeeperPaths);
    }

    @Bean
    @ConditionalOnMissingBean(value={SchemaSourceRepository.class})
    @ConditionalOnProperty(value={"schema.repository.type"}, havingValue="schema_repo")
    public SchemaSourceRepository schemaRepoSchemaSourceRepository(Client jerseyClient) {
        JerseySchemaRepoClient client = new JerseySchemaRepoClient(jerseyClient, URI.create(this.schemaRepositoryProperties.getServerUrl()));
        return new SchemaRepoSchemaSourceRepository((SchemaRepoClient)client);
    }

    @Bean
    @ConditionalOnMissingBean(value={SchemaSourceRepository.class})
    @ConditionalOnProperty(value={"schema.repository.type"}, havingValue="topic_field")
    public SchemaSourceRepository topicFieldSchemaSourceRepository() {
        return new TopicFieldSchemaSourceRepository(this.topicService);
    }

    @Bean
    public SchemaSourceProvider schemaSourceProvider(SchemaSourceRepository schemaSourceRepository) {
        return schemaSourceRepository;
    }

    @Bean
    public SchemaRepository aggregateSchemaRepository(SchemaSourceProvider schemaSourceProvider, ObjectMapper objectMapper) {
        SimpleSchemaVersionsRepository versionsRepository = new SimpleSchemaVersionsRepository(schemaSourceProvider);
        DirectCompiledSchemaRepository avroSchemaRepository = new DirectCompiledSchemaRepository(schemaSourceProvider, SchemaCompilersFactory.avroSchemaCompiler());
        DirectCompiledSchemaRepository jsonSchemaRepository = new DirectCompiledSchemaRepository(schemaSourceProvider, SchemaCompilersFactory.jsonSchemaCompiler((ObjectMapper)objectMapper));
        return new SchemaRepository((SchemaVersionsRepository)versionsRepository, (CompiledSchemaRepository)avroSchemaRepository, (CompiledSchemaRepository)jsonSchemaRepository);
    }
}

