/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.schema.validator;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.common.exception.InvalidSchemaException;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.SchemaValidator;

@Component
public class AvroSchemaValidator
implements SchemaValidator {
    @Override
    public void check(String schema) throws InvalidSchemaException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schema) ? 1 : 0) != 0, (Object)"Message schema cannot be empty");
        try {
            new Schema.Parser().parse(schema);
        }
        catch (SchemaParseException e) {
            throw new InvalidSchemaException((Throwable)e);
        }
    }
}

