/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.schema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.common.exception.InvalidSchemaException;
import pl.allegro.tech.hermes.management.infrastructure.schema.validator.SchemaValidator;

@Component
public class JsonSchemaValidator
implements SchemaValidator {
    private final JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.byDefault();
    private final ObjectMapper objectMapper;

    @Autowired
    public JsonSchemaValidator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void check(String schema) throws InvalidSchemaException {
        ArrayList errors = new ArrayList();
        try {
            JsonNode schemaNode = this.objectMapper.readTree(schema);
            ProcessingReport report = this.jsonSchemaFactory.getSyntaxValidator().validateSchema(schemaNode);
            StreamSupport.stream(report.spliterator(), false).forEach(e -> errors.add(e.getMessage()));
        }
        catch (IOException e2) {
            throw new InvalidSchemaException((Throwable)e2);
        }
        if (!errors.isEmpty()) {
            throw new InvalidSchemaException(errors);
        }
    }
}

