/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api.mappers;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.validation.ValidationError;
import org.glassfish.jersey.server.validation.internal.ValidationHelper;
import pl.allegro.tech.hermes.api.ErrorCode;
import pl.allegro.tech.hermes.management.api.mappers.AbstractExceptionMapper;

@Provider
public class ConstraintViolationMapper
extends AbstractExceptionMapper<ConstraintViolationException> {
    @Override
    Response.Status httpStatus() {
        return Response.Status.BAD_REQUEST;
    }

    @Override
    ErrorCode errorCode() {
        return ErrorCode.VALIDATION_ERROR;
    }

    @Override
    public String errorMessage(ConstraintViolationException exception) {
        return this.prepareMessage(exception);
    }

    private String prepareMessage(ConstraintViolationException ex) {
        List errors = Lists.transform((List)ValidationHelper.constraintViolationToValidationErrors((ConstraintViolationException)ex), (Function)new ValidationErrorConverter());
        return Joiner.on((String)"; ").join((Iterable)errors);
    }

    private static final class ValidationErrorConverter
    implements Function<ValidationError, String> {
        private ValidationErrorConverter() {
        }

        public String apply(ValidationError input) {
            return input.getMessageTemplate() + " " + input.getPath() + " " + input.getMessage();
        }
    }
}

