/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service.retransmit;

import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.common.kafka.KafkaTopic;
import pl.allegro.tech.hermes.common.message.wrapper.MessageContentWrapper;
import pl.allegro.tech.hermes.common.message.wrapper.UnsupportedContentTypeException;
import pl.allegro.tech.hermes.common.message.wrapper.UnwrappedMessageContent;
import pl.allegro.tech.hermes.domain.topic.schema.SchemaRepository;
import pl.allegro.tech.hermes.management.infrastructure.kafka.service.KafkaRawMessageReader;

class KafkaTimestampExtractor {
    private final Topic topic;
    private final KafkaTopic kafkaTopic;
    private final int partition;
    private final KafkaRawMessageReader kafkaRawMessageReader;
    private final MessageContentWrapper messageContentWrapper;
    private final SchemaRepository schemaRepository;

    KafkaTimestampExtractor(Topic topic, KafkaTopic kafkaTopic, int partition, KafkaRawMessageReader kafkaRawMessageReader, MessageContentWrapper messageContentWrapper, SchemaRepository schemaRepository) {
        this.topic = topic;
        this.kafkaTopic = kafkaTopic;
        this.partition = partition;
        this.kafkaRawMessageReader = kafkaRawMessageReader;
        this.messageContentWrapper = messageContentWrapper;
        this.schemaRepository = schemaRepository;
    }

    public long extract(Long offset) {
        byte[] message = this.kafkaRawMessageReader.readMessage(this.kafkaTopic, this.partition, offset);
        return this.unwrapContent(message).getMessageMetadata().getTimestamp();
    }

    private UnwrappedMessageContent unwrapContent(byte[] message) {
        switch (this.kafkaTopic.contentType()) {
            case AVRO: {
                return this.messageContentWrapper.unwrapAvro(message, this.topic, version -> this.schemaRepository.getAvroSchema(this.topic, version), arg_0 -> ((SchemaRepository)this.schemaRepository).versions(arg_0));
            }
            case JSON: {
                return this.messageContentWrapper.unwrapJson(message);
            }
        }
        throw new UnsupportedContentTypeException(this.topic);
    }
}

