/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.group;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Group;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.api.Query;
import pl.allegro.tech.hermes.api.helpers.Patch;
import pl.allegro.tech.hermes.domain.group.GroupNotExistsException;
import pl.allegro.tech.hermes.domain.group.GroupRepository;
import pl.allegro.tech.hermes.infrastructure.MalformedDataException;

@Component
public class GroupService {
    private static final Logger logger = LoggerFactory.getLogger(GroupService.class);
    private final GroupRepository groupRepository;

    @Autowired
    public GroupService(GroupRepository groupRepository) {
        this.groupRepository = groupRepository;
    }

    public List<Group> listGroups() {
        return this.groupRepository.listGroups();
    }

    public List<String> listGroupNames() {
        return this.groupRepository.listGroupNames();
    }

    public Group getGroupDetails(String groupName) {
        return this.groupRepository.getGroupDetails(groupName);
    }

    public String createGroup(Group group) {
        this.groupRepository.createGroup(group);
        return "";
    }

    public void removeGroup(String groupName) {
        this.groupRepository.removeGroup(groupName);
    }

    public void checkGroupExists(String groupName) {
        if (!this.groupRepository.groupExists(groupName)) {
            throw new GroupNotExistsException(groupName);
        }
    }

    public void updateGroup(String groupName, PatchData patch) {
        try {
            Group retrieved = this.groupRepository.getGroupDetails(groupName);
            Group modified = (Group)Patch.apply((Object)retrieved, (PatchData)patch);
            this.groupRepository.updateGroup(modified);
        }
        catch (MalformedDataException exception) {
            logger.warn("Problem with reading details of group {}.", (Object)groupName);
            throw exception;
        }
    }

    public List<Group> queryGroup(Query<Group> query) {
        return query.filter(this.listGroups()).collect(Collectors.toList());
    }
}

