/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import pl.allegro.tech.hermes.api.Query;
import pl.allegro.tech.hermes.management.infrastructure.query.matcher.Matcher;

public class MatcherQuery<T>
implements Query<T> {
    private final Matcher matcher;
    private final ObjectMapper objectMapper;

    private MatcherQuery(Matcher matcher, ObjectMapper objectMapper) {
        this.matcher = matcher;
        this.objectMapper = objectMapper;
    }

    public Stream<T> filter(Stream<T> input) {
        return input.filter(this.getPredicate());
    }

    public Predicate<T> getPredicate() {
        return value -> this.matcher.match(this.convertToMap(value));
    }

    private Map convertToMap(T value) {
        return (Map)this.objectMapper.convertValue(value, Map.class);
    }

    public static <T> Query<T> fromMatcher(Matcher matcher, ObjectMapper objectMapper) {
        return new MatcherQuery<T>(matcher, objectMapper);
    }
}

