/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.supportTeam;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.SupportTeam;
import pl.allegro.tech.hermes.management.config.SupportTeamServiceProperties;
import pl.allegro.tech.hermes.management.domain.supportTeam.CouldNotLoadSupportTeamsException;
import pl.allegro.tech.hermes.management.domain.supportTeam.SupportTeamService;

@Component
public class SupportTeamCache {
    private final LoadingCache<String, List<SupportTeam>> cache;

    @Autowired
    public SupportTeamCache(final SupportTeamService supportTeamService, SupportTeamServiceProperties supportTeamServiceProperties) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(supportTeamServiceProperties.getCacheDurationSeconds().longValue(), TimeUnit.SECONDS).maximumSize(supportTeamServiceProperties.getCacheSize().longValue()).build((CacheLoader)new CacheLoader<String, List<SupportTeam>>(){

            public List<SupportTeam> load(String searchString) throws Exception {
                return supportTeamService.getSupportTeams(searchString);
            }
        });
    }

    public List<SupportTeam> getSupportTeams(String searchString) {
        try {
            return (List)this.cache.get((Object)searchString);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new CouldNotLoadSupportTeamsException(e);
        }
    }
}

