/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.health;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.management.domain.mode.ModeService;
import pl.allegro.tech.hermes.management.infrastructure.zookeeper.ZookeeperClient;

class HealthCheckTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HealthCheckTask.class);
    private final Collection<ZookeeperClient> zookeeperClients;
    private final String healthCheckPath;
    private final ObjectMapper objectMapper;
    private final ModeService modeService;

    HealthCheckTask(Collection<ZookeeperClient> zookeeperClients, String healthCheckPath, ObjectMapper objectMapper, ModeService modeService) {
        this.zookeeperClients = zookeeperClients;
        this.healthCheckPath = healthCheckPath;
        this.objectMapper = objectMapper;
        this.modeService = modeService;
    }

    @Override
    public void run() {
        List<HealthCheckResult> healthCheckResults = this.zookeeperClients.stream().map(this::doHealthCheck).collect(Collectors.toList());
        this.updateMode(healthCheckResults);
    }

    private HealthCheckResult doHealthCheck(ZookeeperClient zookeeperClient) {
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        try {
            zookeeperClient.ensurePathExists(this.healthCheckPath);
            zookeeperClient.getCuratorFramework().setData().forPath(this.healthCheckPath, this.objectMapper.writeValueAsBytes((Object)timestamp));
            logger.info("Storage healthy for datacenter {}", (Object)zookeeperClient.getDatacenterName());
            return HealthCheckResult.HEALTHY;
        }
        catch (Exception e) {
            logger.error("Storage health check failed for datacenter {}", (Object)zookeeperClient.getDatacenterName(), (Object)e);
            return HealthCheckResult.UNHEALTHY;
        }
    }

    private void updateMode(List<HealthCheckResult> healthCheckResults) {
        if (healthCheckResults.contains((Object)HealthCheckResult.UNHEALTHY)) {
            this.modeService.setMode(ModeService.ManagementMode.READ_ONLY);
        } else {
            this.modeService.setMode(ModeService.ManagementMode.READ_WRITE);
        }
    }

    private static enum HealthCheckResult {
        HEALTHY,
        UNHEALTHY;

    }
}

