/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;

public class ZookeeperClient {
    private final CuratorFramework curatorFramework;
    private final String datacenterName;

    public ZookeeperClient(CuratorFramework curatorFramework, String datacenterName) {
        this.curatorFramework = curatorFramework;
        this.datacenterName = datacenterName;
    }

    public CuratorFramework getCuratorFramework() {
        return this.curatorFramework;
    }

    public String getDatacenterName() {
        return this.datacenterName;
    }

    public void ensurePathExists(String path) {
        try {
            if (this.curatorFramework.checkExists().forPath(path) == null) {
                this.curatorFramework.create().creatingParentsIfNeeded().forPath(path);
            }
        }
        catch (Exception e) {
            throw new InternalProcessingException("Could not ensure existence of path: " + path);
        }
    }
}

