/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health.problem;

import java.util.Optional;
import pl.allegro.tech.hermes.api.SubscriptionHealthProblem;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthProblemIndicator;

public class TimingOutIndicator
implements SubscriptionHealthProblemIndicator {
    private final double maxTimeoutsRatio;
    private final double minSubscriptionRateForReliableMetrics;

    public TimingOutIndicator(double maxTimeoutsRatio, double minSubscriptionRateForReliableMetrics) {
        this.maxTimeoutsRatio = maxTimeoutsRatio;
        this.minSubscriptionRateForReliableMetrics = minSubscriptionRateForReliableMetrics;
    }

    @Override
    public Optional<SubscriptionHealthProblem> getProblem(SubscriptionHealthContext context) {
        if (this.areSubscriptionMetricsReliable(context) && this.isTimeoutsRateHigh(context)) {
            return Optional.of(SubscriptionHealthProblem.timingOut((double)context.getTimeoutsRate(), (String)context.getSubscription().getQualifiedName().toString()));
        }
        return Optional.empty();
    }

    private boolean areSubscriptionMetricsReliable(SubscriptionHealthContext context) {
        return context.getSubscriptionRateRespectingDeliveryType() > this.minSubscriptionRateForReliableMetrics;
    }

    private boolean isTimeoutsRateHigh(SubscriptionHealthContext context) {
        double timeoutsRate = context.getTimeoutsRate();
        return timeoutsRate > this.maxTimeoutsRatio * context.getSubscriptionRateRespectingDeliveryType();
    }
}

