/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.validator;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.management.domain.subscription.validator.SubscriptionValidationException;

@Component
public class MessageFilterTypeValidator {
    private static final String ERROR_MESSAGE = "Message filter type %s doesn't match topic content type %s";
    private static final Set<ContentTypeFilterTypePair> VALID_TYPES_COMBINATIONS = new HashSet<ContentTypeFilterTypePair>(Arrays.asList(new ContentTypeFilterTypePair(ContentType.JSON, "jsonpath"), new ContentTypeFilterTypePair(ContentType.JSON, "header"), new ContentTypeFilterTypePair(ContentType.AVRO, "avropath"), new ContentTypeFilterTypePair(ContentType.AVRO, "header")));

    public void check(Subscription subscription, Topic topic) {
        subscription.getFilters().stream().map(filter -> new ContentTypeFilterTypePair(topic.getContentType(), filter.getType())).forEach(pair -> this.checkTypeMaching((ContentTypeFilterTypePair)pair));
    }

    private void checkTypeMaching(ContentTypeFilterTypePair pair) {
        if (!VALID_TYPES_COMBINATIONS.contains(pair)) {
            throw new SubscriptionValidationException(String.format(ERROR_MESSAGE, pair.filterType, pair.contentType));
        }
    }

    static class ContentTypeFilterTypePair {
        private ContentType contentType;
        private String filterType;

        ContentTypeFilterTypePair(ContentType contentType, String filterType) {
            this.contentType = contentType;
            this.filterType = filterType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContentTypeFilterTypePair validPair = (ContentTypeFilterTypePair)o;
            return this.contentType == validPair.contentType && Objects.equal((Object)this.filterType, (Object)validPair.filterType);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.contentType, this.filterType});
        }
    }
}

